<!--
BOSCH Security Systems (Ottobrunn)
Project: Magic.Panel
Author: Michael Ziegel
Created: 1-10-2009
$Revision: 1.6 $ 
Last locked:   $Date: 2013/11/21 15:45:22GMT $
Last change by $Author: Maria Lux (lux2ot) $
History: 
$Log: XSLT/conv-lt-2-7-0-to-2-7-0.xsl  $
Revision 1.6 2013/11/21 15:45:22GMT Maria Lux (lux2ot) 
function ExtendGLOBAL_OFFSET_TABLE corrected
Revision 1.5 2011/06/14 12:56:06MESZ Michael Ziegel (zi82ot) 
do not remove ASSIGNED_MTS_NODES in remote keypad
Revision 1.4 2011/05/18 10:26:06MESZ Michael Ziegel (zi82ot) 
insert LINE_SUPERVISION in AUXPOWER of BCMB or LSN
Revision 1.3 2011/02/08 16:15:41MEZ Michael Ziegel (zi82ot) 
aux1CreepI_max init with 0
Revision 1.2 2011/01/28 11:01:30CET Michael Ziegel (zi82ot) 
dont convert LSN-structure if already converted
Revision 1.1 2010/10/11 13:24:51CEST Michael Ziegel (zi82ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj
Revision 1.4 2010/07/13 16:18:00CEST Michael Ziegel (zi82ot) 
Member moved from Conversion/XSLT/conv-lt-2-8-0-to-2-8-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to XSLT/conv-lt-2-8-0-to-2-8-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj.
Revision 1.3 2010/07/13 16:18:00CEST Michael Ziegel (zi82ot) 
Counter-handling in includefile counter-2-x.xsl
Revision 1.2 2010/05/21 11:26:38CEST Michael Ziegel (zi82ot) 
copied form 2.6.0
Revision 1.1 2010/05/21 11:25:50CEST Michael Ziegel (zi82ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
Revision 1.12 2010/03/26 15:22:14CET Michael Ziegel (zi82ot) 
LSNI_EOL_4W in convertion-template
Revision 1.11 2010/03/26 10:43:27CET Michael Ziegel (zi82ot) 
remove 'batteryBackup'
Revision 1.10 2010/02/19 14:13:00CET Michael Ziegel (zi82ot) 
Schema version 2.5.2 for LSN###_MODULE/detect4WShort introduced
Revision 1.9 2010/02/17 16:30:17CET Michael Ziegel (zi82ot) 
add auxcreepImax to LSN..Modules
Revision 1.8 2009/11/27 16:20:56CET Michael Ziegel (zi82ot) 
RLHVI as HVAC
Revision 1.7 2009/11/17 17:05:23CET Michael Ziegel (zi82ot) 
handling of stubs, backpointer = 255
Revision 1.6 2009/11/11 15:39:25CET Michael Ziegel (zi82ot) 
conversion of compoundstates revised and fixed
Revision 1.5 2009/10/08 15:13:38CEST Michael Ziegel (zi82ot) 
missing DO-nodes
Revision 1.4 2009/10/08 12:03:36CEST Michael Ziegel (zi82ot) 
.
Revision 1.3 2009/10/05 14:44:57CEST Michael Ziegel (zi82ot) 
branch added
Revision 1.2 2009/10/01 15:07:39CEST Michael Ziegel (zi82ot) 
conv-lt-2-6-0 to 2-6-0
Revision 1.1 2009/10/01 14:12:53CEST Michael Ziegel (zi82ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://bosch.com">
   <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
   <!--##############  BEGIN Namspace cfg   ####################-->
   <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.6 $" versionscope="ALL_FILES" backup="true" backupdir="cebackup"/>
   <cfg:Description lang="DE">Konvertiere Konfiguration mit Schemaversionen kleiner V 2.7.0 zu Schema V 2.7.0, Parameter newversion=2.7.0</cfg:Description>
   <cfg:Description lang="EN">Convert pre V 2.7.0 configurations to V 2.7.0, parameter newversion=2.7.0</cfg:Description>
   <!--##############  END Namspace cfg   ####################-->
   <xsl:include href="create-net.xsl"/>
   <xsl:include href="counter-2-x.xsl"/>
   <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
   <!-- ################################## NEW in VERSION 2.0.1 ######################## -->
   <!-- Remove all network data from local configuration -->
   <!-- CHANNEL/target -->
   <xsl:template match="CHANNEL/target">
      <xsl:element name="target">
         <xsl:choose>
            <xsl:when test="contains(string(.),'MP_SI_PANEL')">
               <xsl:text>MP_SI_PANEL.1.0</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="."/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- NEW TRIGGER_STATE and NEW CONDITION_STATE with isRemote-->
   <xsl:template match="TRIGGER_STATE | CONDITION_STATE">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="isRemote = false()">
            <xsl:element name="isRemote">
               <xsl:text>ST_NO</xsl:text>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- ADD NODE REPLICATED_SIS-->
   <xsl:template match="EXPORTS">
      <xsl:element name="EXPORTS">
         <xsl:element name="netCRC">
            <xsl:value-of select="netCRC"/>
         </xsl:element>
         <xsl:element name="REPLICATED_SIS">
            <xsl:apply-templates select="REPLICATED_SIS/*"/>
         </xsl:element>
         <xsl:element name="REPLICATED_COUNTERS">
            <xsl:apply-templates select="REPLICATED_COUNTERS/*"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- ADD NODE USED_SIS-->
   <xsl:template match="IMPORTS">
      <xsl:element name="IMPORTS">
         <xsl:element name="netCRC">
            <xsl:value-of select="netCRC"/>
         </xsl:element>
         <xsl:element name="USED_SIS">
            <xsl:apply-templates select="USED_SIS/*"/>
         </xsl:element>
         <xsl:element name="USED_COUNTERS">
            <xsl:apply-templates select="USED_COUNTERS/*"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- ################################## NEW in VERSION 2.0.2 ######################## -->
   <!-- ADD PANEL/troubleCausesAlarm -->
   <xsl:template match="PANEL/resetMode">
      <xsl:element name="resetMode">
         <xsl:value-of select="."/>
      </xsl:element>
      <!-- if not already there -->
      <xsl:if test="../troubleCausesAlarm = false()">
         <xsl:element name="troubleCausesAlarm">ST_NO</xsl:element>
      </xsl:if>
   </xsl:template>
   <!-- ADD OPERATOR/scope-->
   <xsl:template match="OPERATOR/level">
      <xsl:element name="level">
         <xsl:value-of select="."/>
      </xsl:element>
      <!-- if not already there -->
      <xsl:if test="../scope = false()">
         <xsl:element name="scope">
            <xsl:choose>
               <xsl:when test="../id = '9' or ../id = '10001' or ../id = '10008'">
                  <xsl:text>NETWORK</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>LOCAL</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
      </xsl:if>
   </xsl:template>
   <!-- ADD OPERATOR_ADMIN/maxIdleTime-->
   <xsl:template match="OPERATOR_ADMIN/is24hMasterPwd">
      <xsl:element name="is24hMasterPwd">
         <xsl:value-of select="."/>
      </xsl:element>
      <!-- if not already there -->
      <xsl:if test="../maxIdleTime = false()">
         <xsl:element name="maxIdleTime">60</xsl:element>
      </xsl:if>
   </xsl:template>
   <!-- ADD New Rights-->
   <xsl:template match="RIGHT_MANAGEMENT">
      <xsl:element name="RIGHT_MANAGEMENT">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name() = 'LEVEL'">
                  <xsl:call-template name="UpdateLevel">
                     <xsl:with-param name="LevelId" select="./id"/>
                  </xsl:call-template>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- Change RIGHT Configure -->
   <xsl:template match="RIGHT">
      <xsl:element name="RIGHT">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name() = 'action' and . = 'OPM_ACT_CONFIGURE' and ../type = 'OPM_CDT_CONFIGURE' and ../target = 'OPM_SI_MATCHALL'">
                  <xsl:element name="{name()}">OPM_ACT_MATCHALL</xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- ADD new RIGHTS to LEVEL 1 and 3-->
   <xsl:template name="UpdateLevel">
      <xsl:param name="LevelId"/>
      <xsl:element name="LEVEL">
         <xsl:for-each select="./*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <!-- in LEVEL 1 there are 2 RIGHTs and id = 3 if not yet added-->
         <xsl:if test="$LevelId = '1' and count(./*) = 3">
            <xsl:call-template name="CreateRightLanguage"/>
         </xsl:if>
         <!-- in LEVEL 3  there are 9 RIGHTs and id = 10 if not yet added-->
         <xsl:if test="$LevelId = '3' and count(./*) = 10">
            <xsl:call-template name="CreateRightUART"/>
            <xsl:call-template name="CreateRightFireExt"/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!--  RIGHT to change Language-->
   <xsl:template name="CreateRightLanguage">
      <xsl:element name="RIGHT">
         <xsl:element name="type">OPM_CDT_CONFIGURE</xsl:element>
         <xsl:element name="action">OPM_ACT_CHANGE</xsl:element>
         <xsl:element name="target">OPM_SI_LANGUAGE</xsl:element>
         <xsl:element name="on">ST_YES</xsl:element>
         <xsl:element name="off">ST_YES</xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- RIGHT to switch UART -->
   <xsl:template name="CreateRightUART">
      <xsl:element name="RIGHT">
         <xsl:element name="type">OPM_CDT_ACTIVATION</xsl:element>
         <xsl:element name="action">OPM_ACT_CHANGE</xsl:element>
         <xsl:element name="target">OPM_SI_UART</xsl:element>
         <xsl:element name="on">ST_YES</xsl:element>
         <xsl:element name="off">ST_YES</xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- RIGHT for Activate FireExt -->
   <xsl:template name="CreateRightFireExt">
      <xsl:element name="RIGHT">
         <xsl:element name="type">OPM_CDT_ACTIVATION</xsl:element>
         <xsl:element name="action">OPM_ACT_CONTINUOUS</xsl:element>
         <xsl:element name="target">OPM_SI_FIREEXTINGUISHER</xsl:element>
         <xsl:element name="on">ST_YES</xsl:element>
         <xsl:element name="off">ST_YES</xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- ################################## NEW in VERSION 2.0.3 ######################## -->
   <!-- ONBOARD is modified -->
   <!--  1. GROUND only if FPA5000, not for RK -->
   <!--  2. OB_INPUTS are inserted for FPA5000 and RK -->
   <!--  3. OB_POWER_INS are inserted for RK only -->
   <!--  4. (2.0.7) CANBUS 3x -->
   <xsl:template match="ONBOARD">
      <xsl:element name="ONBOARD">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
            <xsl:if test="name() = 'RS232' and ../CANBUS=false()">
               <xsl:call-template name="AddCANBUS">
                  <xsl:with-param name="PortNbr">1</xsl:with-param>
               </xsl:call-template>
               <xsl:call-template name="AddCANBUS">
                  <xsl:with-param name="PortNbr">2</xsl:with-param>
               </xsl:call-template>
               <xsl:call-template name="AddCANBUS">
                  <xsl:with-param name="PortNbr">3</xsl:with-param>
               </xsl:call-template>
            </xsl:if>
         </xsl:for-each>
         <xsl:if test="OB_INPUTS=false()">
            <xsl:call-template name="AddOB_INPUTS"/>
         </xsl:if>
         <xsl:if test="ancestor::NODE/nodeType='FPA5000_RK' and OB_POWER_INS=false()">
            <xsl:call-template name="AddOB_POWER_INS"/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- GROUND only if FPA5000, not for RK and also if no anchestor::NODE like in pre 2.0 configurations -->
   <xsl:template match="GROUND">
      <xsl:if test="ancestor::NODE=false() or ancestor::NODE/nodeType='FPA5000' or ancestor::NODE/nodeType='FPA1200_EN'">
         <xsl:element name="GROUND">
            <xsl:apply-templates/>
         </xsl:element>
      </xsl:if>
   </xsl:template>
   <!-- in case of beeing a remote keypad no SETs in SET_ADMIN
   <xsl:template match="SETS_ADMIN">
      <xsl:element name="SETS_ADMIN">
         <xsl:if test="ancestor::NODE=false() or ancestor::NODE/nodeType='FPA5000' or ancestor::NODE/nodeType='FPA1200_EN'">
            <xsl:apply-templates/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
  is dropped 21.5. 2010 after detecting that it is possible to create sets in FMR, 
  which than will be dropped on the next conversion -->
   <!-- -->
   <xsl:template name="AddCANBUS">
      <xsl:param name="PortNbr"/>
      <xsl:element name="CANBUS">
         <xsl:element name="port">
            <xsl:value-of select="$PortNbr"/>
         </xsl:element>
         <xsl:element name="siType">MP_SI_CANBUS</xsl:element>
         <xsl:element name="enabled">
            <xsl:choose>
               <xsl:when test="$PortNbr = '2' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[1]/connectedToNetlineNbr = '0'">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <xsl:when test="$PortNbr = '3' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[2]/connectedToNetlineNbr = '0'">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
               <xsl:when test="$PortNbr = '2' and ancestor::NODE=false()">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
               <xsl:when test="$PortNbr = '3' and ancestor::NODE=false()">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>ST_YES</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template name="AddOB_INPUTS">
      <xsl:element name="OB_INPUTS">
         <xsl:element name="slot">136</xsl:element>
         <xsl:call-template name="AddINPUT">
            <xsl:with-param name="PortNbr" select="'1'"/>
         </xsl:call-template>
         <xsl:call-template name="AddINPUT">
            <xsl:with-param name="PortNbr" select="'2'"/>
         </xsl:call-template>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template name="AddINPUT">
      <xsl:param name="PortNbr"/>
      <xsl:element name="INPUT">
         <xsl:element name="siType">MP_SI_POINT</xsl:element>
         <xsl:element name="port">
            <xsl:value-of select="$PortNbr"/>
         </xsl:element>
         <xsl:element name="siNumber">0</xsl:element>
         <xsl:element name="subNumber">0</xsl:element>
         <xsl:element name="label"/>
         <xsl:element name="bypassable">ST_YES</xsl:element>
         <xsl:element name="blockable">ST_YES</xsl:element>
         <xsl:element name="usageType">MP_UT_SUPERVISORY</xsl:element>
         <xsl:element name="dayNightMode">ST_NO</xsl:element>
         <xsl:element name="andDetector">ST_NO</xsl:element>
         <xsl:element name="andZoneNr">0</xsl:element>
         <xsl:element name="andLatching">ST_NO</xsl:element>
         <xsl:element name="resetOutput">0.0.0.0</xsl:element>
         <xsl:element name="resetTime">0</xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template name="AddOB_POWER_INS">
      <xsl:element name="OB_POWER_INS">
         <xsl:element name="slot">137</xsl:element>
         <xsl:call-template name="AddMAINPOWER"/>
         <xsl:call-template name="AddMAINPOWER"/>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template name="AddMAINPOWER">
      <xsl:element name="MAINPOWER">
         <xsl:element name="siType">MP_SI_MAINPOWER</xsl:element>
         <xsl:element name="siNumber">0</xsl:element>
         <xsl:element name="label"/>
         <xsl:element name="delayForTrouble">0</xsl:element>
      </xsl:element>
   </xsl:template>
   <!--  LOGICAL_GROUPING is modified -->
   <!-- BEGIN ################################## FOR less 1.3.0 VERSIONS  ######################## -->
   <!--  new element MTS from old FAT, this template is implemented in included conv-lt-1-3-0-to-1-3-0.xsl too, but is found first here if target is 2.0.7 -->
   <xsl:template match="LOGICAL_GROUPING/FAT_ADMIN/FAT">
      <xsl:element name="MTS">
         <xsl:element name="subType">
            <xsl:choose>
               <xsl:when test="fat != $NOT_TRANS or coupler != $NOT_TRANS">
                  <xsl:text>FMS</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>FAT</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:element name="redundantSiNumber">
            <xsl:text>0</xsl:text>
         </xsl:element>
         <xsl:element name="TRANSMISSION_TABLE">
            <xsl:for-each select="*">
               <xsl:choose>
                  <xsl:when test="name() = 'UART' or name() = 'OB_UART' or name() = 'siNumber' or name() = 'label' or name() = 'connectedWith'">
                     <!-- do nothing -->
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:element name="{name()}">
                        <xsl:choose>
                           <xsl:when test=". = $NOT_TRANS">
                              <xsl:text>ST_NO</xsl:text>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:text>ST_YES</xsl:text>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:element>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="ExtendTRANSMISSION_TABLE"/>
         </xsl:element>
         <xsl:element name="MTS_CONNECTION">
            <xsl:element name="connectedWith">
               <xsl:value-of select="connectedWith"/>
            </xsl:element>
            <xsl:for-each select="*">
               <xsl:if test="name() = 'UART' or name() = 'OB_UART'">
                  <xsl:element name="{name()}">
                     <xsl:apply-templates/>
                  </xsl:element>
               </xsl:if>
            </xsl:for-each>
            <xsl:call-template name="CreateProtocolValues"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- replace existing FAT_ADMIN by MTS_ADMIN and insert ADDRESSMANAGMENT after it in LOGICAL_GROUPING -->
   <!-- , this template is implemented in included conv-lt-1-3-0-to-1-3-0.xsl too, but is found first here if target is 2.0.7 -->
   <xsl:template match="NETWORK/PANEL/LOGICAL_GROUPING/FAT_ADMIN">
      <xsl:if test="FAT">
         <xsl:element name="MTS_ADMIN">
            <xsl:for-each select="FAT">
               <xsl:apply-templates select="."/>
            </xsl:for-each>
         </xsl:element>
         <xsl:element name="ADDRESS_MANAGEMENT">
            <xsl:call-template name="CreateGlobalOffsetTableFromLess130"/>
         </xsl:element>
      </xsl:if>
   </xsl:template>
   <!-- Create GLOBAL_OFFSET_TABLE from less 1.3.0 versions-->
   <xsl:template name="CreateGlobalOffsetTableFromLess130">
      <xsl:element name="GLOBAL_OFFSET_TABLE">
         <xsl:element name="panel">
            <xsl:if test="FAT/panel != $NOT_TRANS">
               <xsl:value-of select="FAT/panel"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="point">
            <xsl:if test="FAT/point != $NOT_TRANS">
               <xsl:value-of select="FAT/point"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="module">
            <xsl:if test="FAT/module != $NOT_TRANS">
               <xsl:value-of select="FAT/module"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="coupler">
            <xsl:if test="FAT/coupler != $NOT_TRANS">
               <xsl:value-of select="FAT/coupler"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="control">
            <xsl:if test="FAT/control != $NOT_TRANS">
               <xsl:value-of select="FAT/control"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="input">
            <xsl:if test="FAT/input != $NOT_TRANS">
               <xsl:value-of select="FAT/input"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="citytie">
            <xsl:if test="FAT/citytie != $NOT_TRANS">
               <xsl:value-of select="FAT/citytie"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="fireextinguisher">
            <xsl:if test="FAT/fireextinguisher != $NOT_TRANS">
               <xsl:value-of select="FAT/fireextinguisher"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="nac">
            <xsl:if test="FAT/nac != $NOT_TRANS">
               <xsl:value-of select="FAT/nac"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="buzzer">
            <xsl:if test="FAT/buzzer != $NOT_TRANS">
               <xsl:value-of select="FAT/buzzer"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="hvac">
            <xsl:if test="FAT/hvac != $NOT_TRANS">
               <xsl:value-of select="FAT/hvac"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="doorholder">
            <xsl:if test="FAT/doorholder != $NOT_TRANS">
               <xsl:value-of select="FAT/doorholder"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="keydepot">
            <xsl:if test="FAT/keydepot != $NOT_TRANS">
               <xsl:value-of select="FAT/keydepot"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="status">
            <xsl:if test="FAT/status != $NOT_TRANS">
               <xsl:value-of select="FAT/status"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="dialer">
            <xsl:if test="FAT/dialer != $NOT_TRANS">
               <xsl:value-of select="FAT/dialer"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="printer">
            <xsl:if test="FAT/printer != $NOT_TRANS">
               <xsl:value-of select="FAT/printer"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="fat">
            <xsl:if test="FAT/fat != $NOT_TRANS">
               <xsl:value-of select="FAT/fat"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="fbf">
            <xsl:if test="FAT/fbf != $NOT_TRANS">
               <xsl:value-of select="FAT/fbf"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="set">
            <xsl:if test="FAT/set != $NOT_TRANS">
               <xsl:value-of select="FAT/set"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="auxpower">
            <xsl:if test="FAT/auxpower != $NOT_TRANS">
               <xsl:value-of select="FAT/auxpower"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="battery">
            <xsl:if test="FAT/battery != $NOT_TRANS">
               <xsl:value-of select="FAT/battery"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="mainpower">
            <xsl:if test="FAT/mainpower != $NOT_TRANS">
               <xsl:value-of select="FAT/mainpower"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="railpower">
            <xsl:if test="FAT/railpower != $NOT_TRANS">
               <xsl:value-of select="FAT/railpower"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="ground">
            <xsl:if test="FAT/ground != $NOT_TRANS">
               <xsl:value-of select="FAT/ground"/>
            </xsl:if>
         </xsl:element>
         <xsl:element name="loop">
            <xsl:if test="FAT/loop != $NOT_TRANS">
               <xsl:value-of select="FAT/loop"/>
            </xsl:if>
         </xsl:element>
         <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE">
            <xsl:with-param name="Complete" select="true()"/>
         </xsl:call-template>
      </xsl:element>
   </xsl:template>
   <!-- END ################################## FOR less 1.3.0 VERSIONS  ######################## -->
   <!-- ################################## FOR all 1.x VERSIONS  ######################## -->
   <xsl:template match="LOGICAL_GROUPING">
      <xsl:element name="LOGICAL_GROUPING">
         <xsl:for-each select="*">
            <!--  2.0.7 configs have a mandatory ADDRESS_MANAGEMENT before COUNTER_ADMIN
                 pre 1.3.0  have no ADDRESS_MANAGEMENT at all:
                    1. having an FAT_ADMIN are handled in template match="NETWORK/PANEL/LOGICAL_GROUPING/FAT_ADMIN" above 
                    2. having no FAT_ADMIN are detected here, the ADDRESS_MANAGEMENT including the extensions made in 2.0.4 is inserted 
                  1.3.0 have an optinal ADRRESS_MAGEMENT if an MTS_ADMIN is configured:
                   1. having an ADRRESS_MAGEMENT: the values of the existing have to be taken and the new 2.0.4 extensions have to be appended 
                   2. having no ADRRESS_MAGEMENT: ADDRESS_MANAGEMENT with default values including the extensions made in 2.0.4 is inserted
        -->
            <xsl:if test="name()='COUNTER_ADMIN' and ../FAT_ADMIN=false()">
               <xsl:choose>
                  <xsl:when test="../ADDRESS_MANAGEMENT=false()">
                     <!-- add the mandatory ADDRESS_MANAGEMENT with default values including the extensions made in 2.0.4  -->
                     <xsl:call-template name="AddADDRESS_MANAGEMENT"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <!--  copy the existing ADDRESS_MANAGEMENT and add the extension made in 2.0.4  -->
                     <xsl:call-template name="MoveADDRESS_MANAGEMENT">
                        <xsl:with-param name="From" select="../ADDRESS_MANAGEMENT/GLOBAL_OFFSET_TABLE/*"/>
                     </xsl:call-template>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:if>
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <!-- There is a bug that TIME_CONTROL is lost in older configurations although it is mandatory -->
         <xsl:if test="TIME_CONTROL = false()">
            <xsl:element name="TIME_CONTROL">
               <xsl:call-template name="FillTimeControl"/>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!--  Create a new minimal TIME_CONTROL which can be edited by RPS -->
   <xsl:template name="FillTimeControl">
      <xsl:element name="CHANNELS">
         <xsl:element name="CHANNEL">
            <xsl:element name="id">20</xsl:element>
            <xsl:element name="target">MP_SI_PANEL.1.0</xsl:element>
            <xsl:element name="ON_ACTION"/>
            <xsl:element name="OFF_ACTION"/>
         </xsl:element>
      </xsl:element>
      <xsl:element name="PROGRAMS"/>
      <xsl:element name="DAYS"/>
   </xsl:template>
   <!--   delete ADDRESS_MANAGMENT at the place it is actually-->
   <xsl:template match="ADDRESS_MANAGEMENT"/>
   <!--  EXTENDED STRUCTURE of 2.0.4  -->
   <xsl:template name="MoveADDRESS_MANAGEMENT">
      <xsl:param name="From"/>
      <xsl:element name="ADDRESS_MANAGEMENT">
         <xsl:element name="GLOBAL_OFFSET_TABLE">
            <xsl:for-each select="$From">
               <xsl:element name="{name()}">
                  <xsl:value-of select="."/>
               </xsl:element>
            </xsl:for-each>
            <xsl:if test="$From/../memory = false()">
               <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
            </xsl:if>
            <xsl:if test="$From/../vas = false()">
               <xsl:element name="vas">3425</xsl:element>
            </xsl:if>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!--  EXTENDED STRUCTURE of 2.0.4 -->
   <xsl:template name="AddADDRESS_MANAGEMENT">
      <xsl:element name="ADDRESS_MANAGEMENT">
         <xsl:element name="GLOBAL_OFFSET_TABLE">
            <xsl:element name="panel"/>
            <xsl:element name="point">0</xsl:element>
            <xsl:element name="module">1500</xsl:element>
            <xsl:element name="coupler"/>
            <xsl:element name="control">1000</xsl:element>
            <xsl:element name="input"/>
            <xsl:element name="citytie">2100</xsl:element>
            <xsl:element name="fireextinguisher">2200</xsl:element>
            <xsl:element name="nac">1600</xsl:element>
            <xsl:element name="buzzer"/>
            <xsl:element name="hvac"/>
            <xsl:element name="doorholder">2000</xsl:element>
            <xsl:element name="keydepot">2300</xsl:element>
            <xsl:element name="status"/>
            <xsl:element name="dialer"/>
            <xsl:element name="printer">2400</xsl:element>
            <xsl:element name="fat">2450</xsl:element>
            <xsl:element name="fbf"/>
            <xsl:element name="set"/>
            <xsl:element name="auxpower">2500</xsl:element>
            <xsl:element name="battery">2600</xsl:element>
            <xsl:element name="mainpower">2700</xsl:element>
            <xsl:element name="railpower">2800</xsl:element>
            <xsl:element name="ground">2900</xsl:element>
            <xsl:element name="loop">3000</xsl:element>
            <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!--  -->
   <xsl:template name="ExtendGLOBAL_OFFSET_TABLE">
      <xsl:param name="Complete" select="false()"/>
      <xsl:element name="memory">3100</xsl:element>
      <xsl:element name="canbus">3110</xsl:element>
      <xsl:element name="network">3105</xsl:element>
      <xsl:element name="networknode">3115</xsl:element>
      <xsl:element name="network_line">3400</xsl:element>
      <xsl:element name="topology">3405</xsl:element>
      <xsl:element name="netaddress">3415</xsl:element>
      <xsl:element name="vas">3425</xsl:element>
   </xsl:template>
   <!--  -->
   <xsl:template match="MTS/TRANSMISSION_TABLE">
      <xsl:element name="TRANSMISSION_TABLE">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="memory=false()">
            <xsl:call-template name="ExtendTRANSMISSION_TABLE"/>
         </xsl:if>
         <xsl:if test="vas=false()">
            <xsl:element name="vas">ST_YES</xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <xsl:template match="OFFSET_TABLE">
      <xsl:element name="OFFSET_TABLE">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="memory=false()">
            <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <xsl:template name="ExtendTRANSMISSION_TABLE">
      <xsl:element name="memory">ST_YES</xsl:element>
      <xsl:element name="canbus">ST_YES</xsl:element>
      <xsl:element name="network">ST_YES</xsl:element>
      <xsl:element name="networknode">ST_YES</xsl:element>
      <xsl:element name="network_line">ST_YES</xsl:element>
      <xsl:element name="topology">ST_YES</xsl:element>
      <xsl:element name="netaddress">ST_YES</xsl:element>
   </xsl:template>
   <!--  PRIORITIES are extended -->
   <xsl:template match="PRIORITIES">
      <xsl:element name="PRIORITIES">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <!-- missing watchdogRestart triggers the extension 1 -->
         <xsl:if test="watchdogRestart=false()">
            <xsl:call-template name="ExtendPRIORITIES_1"/>
         </xsl:if>
         <!-- missing warning_heat triggers the extension 2 -->
         <xsl:if test="warning_heat=false()">
            <xsl:call-template name="ExtendPRIORITIES_2"/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- Extend Priorities -->
   <xsl:template name="ExtendPRIORITIES_1">
      <xsl:element name="watchdogRestart">3</xsl:element>
      <xsl:element name="pasWaitForAck">1</xsl:element>
      <xsl:element name="pasInvestigate">1</xsl:element>
      <xsl:element name="netConfigMismatch">1</xsl:element>
      <xsl:element name="unknownItem">1</xsl:element>
      <xsl:element name="missingItem">3</xsl:element>
      <xsl:element name="incompatibleSoftware">1</xsl:element>
      <xsl:element name="incompatibleNetProtocol">1</xsl:element>
   </xsl:template>
   <!-- Extend Priorities for 2.5.0-->
   <xsl:template name="ExtendPRIORITIES_2">
      <xsl:element name="warning_smoke">3</xsl:element>
      <xsl:element name="warning_heat">3</xsl:element>
      <xsl:element name="info_alarm">3</xsl:element>
      <xsl:element name="chemical">5</xsl:element>
   </xsl:template>
   <!-- RK_DATA are extended  by showReportsInLockedState -->
   <xsl:template match="RK_DATA">
      <xsl:element name="RK_DATA">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="showReportsInLockedState = false()">
            <xsl:element name="showReportsInLockedState">ST_YES</xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- NET_INTERFACE is extended  by CAN_PARAM -->
   <xsl:template match="NET_INTERFACE">
      <xsl:element name="NET_INTERFACE">
         <xsl:for-each select="*">
            <xsl:if test="name()!='messageFilter'">
               <xsl:apply-templates select="."/>
            </xsl:if>
         </xsl:for-each>
         <xsl:if test="CAN_PARAM = false()">
            <xsl:call-template name="AddCAN_PARAM"/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <xsl:template name="AddCAN_PARAM">
      <xsl:element name="CAN_PARAM">
         <xsl:element name="bitRate">41666</xsl:element>
         <xsl:element name="propagationSegment">11</xsl:element>
         <xsl:element name="phaseSegment1">2</xsl:element>
         <xsl:element name="phaseSegment2">2</xsl:element>
         <xsl:element name="synchronizationJumpWidth">2</xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- NODE is extended  by subnetMask and gateway -->
   <!-- NODE it was extended by displayNetworkStates in previous version -->
   <!-- the most save way for conversion is to rewrite NOTE in the structure of 2.0.3 using the existing values -->
   <xsl:template match="NODE">
      <xsl:element name="NODE">
         <xsl:element name="netLocalCRC">
            <xsl:value-of select="netLocalCRC"/>
         </xsl:element>
         <xsl:element name="netGroup">
            <xsl:value-of select="netGroup"/>
         </xsl:element>
         <xsl:element name="netNode">
            <xsl:value-of select="netNode"/>
         </xsl:element>
         <xsl:element name="rsn">
            <xsl:value-of select="rsn"/>
         </xsl:element>
         <xsl:element name="nodeType">
            <xsl:value-of select="nodeType"/>
         </xsl:element>
         <xsl:element name="scope">
            <xsl:value-of select="scope"/>
         </xsl:element>
         <xsl:element name="displayNetworkStates">
            <xsl:choose>
               <xsl:when test="displayNetworkStates = false() or displayNetworkStates = ''">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="displayNetworkStates"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:element name="ipAddress">
            <xsl:value-of select="ipAddress"/>
         </xsl:element>
         <xsl:element name="subnetMask">
            <xsl:value-of select="subnetMask"/>
         </xsl:element>
         <xsl:element name="gateway">
            <xsl:value-of select="gateway"/>
         </xsl:element>
         <xsl:element name="syncRequired">
            <xsl:choose>
               <xsl:when test="syncRequired = false() or syncRequired = ''">
                  <xsl:choose>
                     <xsl:when test="scope = 'NETWORK' and descendant::FBF = true()">
                        <xsl:text>ST_YES</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>ST_NO</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="syncRequired"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:if test="nodeType != 'OPC_SERVER'">
            <xsl:element name="NET_INTERFACES">
               <xsl:apply-templates select="NET_INTERFACES/*"/>
            </xsl:element>
            <xsl:element name="EXPORTS">
               <xsl:apply-templates select="EXPORTS/*"/>
            </xsl:element>
            <xsl:element name="IMPORTS">
               <xsl:apply-templates select="IMPORTS/*"/>
            </xsl:element>
            <xsl:element name="ASSIGNED_OPCSVRS">
               <xsl:apply-templates select="ASSIGNED_OPCSVRS/*"/>
            </xsl:element>
         </xsl:if>
         <xsl:if test="nodeType = 'FPA5000' or nodeType = 'FPA1200_EN' or nodeType = 'FPA5000_RK'">
            <xsl:element name="ASSIGNED_MTS_NODES">
               <xsl:apply-templates select="ASSIGNED_MTS_NODES/*"/>
            </xsl:element>
         </xsl:if>
         <!-- for Remote Keypad only -->
         <xsl:if test="nodeType = 'FPA5000_RK'">
            <xsl:element name="CONNECTABLE">
               <xsl:apply-templates select="CONNECTABLE/*"/>
            </xsl:element>
         </xsl:if>
         <xsl:if test="nodeType != 'OPC_SERVER'">
            <xsl:element name="CONFIG_DATA">
               <xsl:apply-templates select="CONFIG_DATA/*"/>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!--  copy explicitly attribute panelEncoding -->
   <xsl:template match="LOCAL_CONFIGURATION">
      <xsl:element name="LOCAL_CONFIGURATION">
         <xsl:attribute name="panelEncoding"><xsl:choose><xsl:when test="@panelEncoding = ''"><xsl:text>ISO-8859-1</xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="@panelEncoding"/></xsl:otherwise></xsl:choose></xsl:attribute>
         <xsl:apply-templates select="*"/>
      </xsl:element>
   </xsl:template>
   <!-- CONDITION_COUNTER/conditionNumber 
this template does not work, because there is a template CONDITION_COUNTER above,
the conversion intended here for 2.0.3 is integrated above
  <xsl:template match="CONDITION_COUNTER/conditionNumber">
  <xsl:choose>
    <xsl:when test="node() = '1' and ancestor::CITYTIE = true()">
    <xsl:text>FIRE_SCOPE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
    <xsl:value-of select="."/>
    </xsl:otherwise>
  </xsl:choose>
  </xsl:template>
-->
   <!-- RULE and RULE_STATE: note must be added -->
   <xsl:template match="RULE | RULE_STATE">
      <xsl:element name="{name()}">
         <xsl:if test="note = false()">
            <xsl:element name="note"/>
         </xsl:if>
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- make existing RULE_STATE sequence to one RULE_STATE_BLOCK -->
   <xsl:template match="RULE_STATE">
      <xsl:choose>
         <xsl:when test="parent::RULE_STATE_BLOCK = false()">
            <xsl:if test="preceding-sibling::RULE_STATE = false()">
               <xsl:element name="RULE_STATE_BLOCK">
                  <xsl:for-each select="../RULE_STATE">
                     <xsl:element name="RULE_STATE">
                        <xsl:apply-templates/>
                     </xsl:element>
                  </xsl:for-each>
               </xsl:element>
            </xsl:if>
         </xsl:when>
         <xsl:otherwise>
            <xsl:for-each select=".">
               <xsl:element name="RULE_STATE">
                  <xsl:apply-templates/>
               </xsl:element>
            </xsl:for-each>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <!-- SET 32 RULES -->
   <xsl:template match="TRIGGER_USER">
      <xsl:choose>
         <xsl:when test="ancestor::SET/siType = 'MP_SI_OUTPUT_GROUP' and ancestor::SET/siNumber = '32' and command = 'MP_CMD_LOGIN' and userId = '9'">
            <xsl:element name="TRIGGER_COUNTER">
               <xsl:element name="triggerSubject">COUNTER</xsl:element>
               <xsl:element name="triggerNumber">OPERATOR9_SCOPE</xsl:element>
               <xsl:element name="threshold">0</xsl:element>
               <xsl:element name="condition">GT</xsl:element>
            </xsl:element>
         </xsl:when>
         <xsl:when test="ancestor::SET/siType = 'MP_SI_OUTPUT_GROUP' and ancestor::SET/siNumber = '32' and command = 'MP_CMD_LOGOFF' and userId = '9'">
            <xsl:element name="TRIGGER_COUNTER">
               <xsl:element name="triggerSubject">COUNTER</xsl:element>
               <xsl:element name="triggerNumber">OPERATOR9_SCOPE</xsl:element>
               <xsl:element name="threshold">0</xsl:element>
               <xsl:element name="condition">LT_EQ</xsl:element>
            </xsl:element>
         </xsl:when>
         <xsl:otherwise>
            <xsl:element name="TRIGGER_USER">
               <xsl:apply-templates select="*"/>
            </xsl:element>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <!-- #################  CHANGES for 2.1.0 ########################### -->
   <!-- INPUT revision and extension -->
   <xsl:template match="INPUT">
      <xsl:element name="INPUT">
         <xsl:element name="siType">
            <xsl:value-of select="siType"/>
         </xsl:element>
         <xsl:element name="port">
            <xsl:choose>
               <xsl:when test="name(..) = 'NTK100'">
                  <xsl:text>9</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="port"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:element>
         <xsl:element name="subNumber">
            <xsl:value-of select="subNumber"/>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:element name="bypassable">
            <xsl:value-of select="bypassable"/>
         </xsl:element>
         <xsl:element name="blockable">
            <xsl:value-of select="blockable"/>
         </xsl:element>
         <xsl:element name="usageType">
            <xsl:value-of select="usageType"/>
         </xsl:element>
         <xsl:element name="dayNightMode">
            <xsl:value-of select="dayNightMode"/>
         </xsl:element>
         <xsl:element name="andDetector">
            <xsl:choose>
               <xsl:when test="andDetector = false()">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="andDetector"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="andZoneNr">
            <xsl:choose>
               <xsl:when test="andZoneNr = false()">
                  <xsl:text>0</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="andZoneNr"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="andLatching">
            <xsl:choose>
               <xsl:when test="andLatching = false()">
                  <xsl:text>ST_NO</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="andLatching"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="resetOutput">
            <xsl:choose>
               <xsl:when test="resetOutput = false()">
                  <xsl:text>0.0.0.0</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="resetOutput"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="resetTime">
            <xsl:choose>
               <xsl:when test="resetTime = false()">
                  <xsl:text>0</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="resetTime"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:if test="name(..) = 'LSNI_IN2' or name(..) = 'LSNI_IN2_D' or name(..) = 'LSNI_IN8R1' or name(..) = 'LSNI_IN1' or name(..) = 'LSNI_OUT8_IN2' or name(..) = 'LSNI_OUT1_IN1'">
            <xsl:element name="operatingMode">
               <xsl:choose>
                  <xsl:when test="operatingMode = false()">
                     <xsl:text>RESISTANCE</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="operatingMode"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
            <xsl:element name="invertActivation">
               <xsl:choose>
                  <xsl:when test="invertActivation = false()">
                     <xsl:text>ST_NO</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="invertActivation"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
            <xsl:element name="thresholdHigh">
               <xsl:choose>
                  <xsl:when test="thresholdHigh = false()">
                     <xsl:text>VOLTAGE_3</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="thresholdHigh"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
            <xsl:element name="thresholdLow">
               <xsl:choose>
                  <xsl:when test="thresholdLow = false()">
                     <xsl:text>VOLTAGE_1</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="thresholdLow"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
            <xsl:element name="usesEOLResistor">
               <xsl:choose>
                  <xsl:when test="usesEOLResistor = false()">
                     <xsl:text>ST_NO</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="usesEOLResistor"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- RELAY revision and extension, write RELAYS with the new order and and insert subType for any RELAY-->
   <xsl:template match="RELAY">
      <xsl:element name="{name()}">
         <xsl:choose>
            <xsl:when test="parent::LSNI_RLE = true()">
               <!--  LSNI_RLE was introduced newly in 2.1.0 and must not be converted or sorted -->
               <xsl:apply-templates select="*"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:element name="siType">
                  <xsl:value-of select="siType"/>
               </xsl:element>
               <xsl:element name="port">
                  <xsl:value-of select="port"/>
               </xsl:element>
               <xsl:element name="siNumber">
                  <xsl:value-of select="siNumber"/>
               </xsl:element>
               <xsl:element name="subNumber">
                  <xsl:value-of select="subNumber"/>
               </xsl:element>
               <xsl:element name="label">
                  <xsl:value-of select="label"/>
               </xsl:element>
               <xsl:element name="subType">
                  <xsl:choose>
                     <xsl:when test="subType = false()">
                        <xsl:choose>
                           <xsl:when test="siType = 'MP_SI_FIREEXTINGUISHER'">
                              <xsl:text>MP_ST_FIREEX_VDS</xsl:text>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:text>MP_ST_NONE</xsl:text>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="subType"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:element>
               <xsl:element name="nacType">
                  <xsl:value-of select="nacType"/>
               </xsl:element>
               <xsl:element name="bypassable">
                  <xsl:value-of select="bypassable"/>
               </xsl:element>
               <xsl:element name="blockable">
                  <xsl:value-of select="blockable"/>
               </xsl:element>
               <xsl:element name="silenceable">
                  <xsl:value-of select="silenceable"/>
               </xsl:element>
               <xsl:element name="drillable">
                  <xsl:value-of select="drillable"/>
               </xsl:element>
               <xsl:element name="restPosition">
                  <xsl:value-of select="restPosition"/>
               </xsl:element>
               <xsl:element name="supervised">
                  <xsl:value-of select="supervised"/>
               </xsl:element>
               <xsl:if test="feedbackVariant = true()">
                  <xsl:element name="feedbackVariant">
                     <xsl:value-of select="feedbackVariant"/>
                  </xsl:element>
               </xsl:if>
               <xsl:if test="feedback = true()">
                  <xsl:element name="feedback">
                     <xsl:value-of select="feedback"/>
                  </xsl:element>
               </xsl:if>
               <xsl:if test="feedbackDelay = true()">
                  <xsl:element name="feedbackDelay">
                     <xsl:value-of select="feedbackDelay"/>
                  </xsl:element>
               </xsl:if>
               <xsl:if test="fault = true()">
                  <xsl:element name="fault">
                     <xsl:value-of select="fault"/>
                  </xsl:element>
               </xsl:if>
               <xsl:if test="feedbackEOL = true()">
                  <xsl:element name="feedbackEOL">
                     <xsl:value-of select="feedbackEOL"/>
                  </xsl:element>
               </xsl:if>
               <xsl:if test="feedbackActivation = true()">
                  <xsl:element name="feedbackActivation">
                     <xsl:value-of select="feedbackActivation"/>
                  </xsl:element>
               </xsl:if>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- LSNRELAY revision and extension, write RELAYS with the new order and and insert subType for any RELAY-->
   <!-- The new element independentInput must be added, the value of it is calculated by looking at the value of feedbackVariant: 
         'F0' stood for no-feedback, this cannot be used any more because independent inputs need values for the resistor setting
          'F1' to 'F12' even if they no feedback is used. -->
   <xsl:template match=" LSNRELAY">
      <xsl:element name="{name()}">
         <xsl:element name="siType">
            <xsl:value-of select="siType"/>
         </xsl:element>
         <xsl:element name="port">
            <xsl:value-of select="port"/>
         </xsl:element>
         <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:element>
         <xsl:element name="subNumber">
            <xsl:value-of select="subNumber"/>
         </xsl:element>
         <xsl:element name="label">
            <xsl:value-of select="label"/>
         </xsl:element>
         <xsl:element name="subType">
            <xsl:choose>
               <xsl:when test="subType = false()">
                  <xsl:text>MP_ST_NONE</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="subType"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="nacType">
            <xsl:value-of select="nacType"/>
         </xsl:element>
         <xsl:element name="bypassable">
            <xsl:value-of select="bypassable"/>
         </xsl:element>
         <xsl:element name="blockable">
            <xsl:value-of select="blockable"/>
         </xsl:element>
         <xsl:element name="silenceable">
            <xsl:value-of select="silenceable"/>
         </xsl:element>
         <xsl:element name="drillable">
            <xsl:value-of select="drillable"/>
         </xsl:element>
         <xsl:element name="restPosition">
            <xsl:value-of select="restPosition"/>
         </xsl:element>
         <xsl:element name="supervised">
            <xsl:value-of select="supervised"/>
         </xsl:element>
         <xsl:if test="feedbackVariant = true()">
            <xsl:element name="feedbackVariant">
               <xsl:choose>
                  <!-- F0 stood for  no feedback used, it is no longer valid and must be set to the default = F1 -->
                  <xsl:when test="feedbackVariant = 'F0'">
                     <xsl:text>F1</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="feedbackVariant"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
         </xsl:if>
         <xsl:if test="feedback = true()">
            <xsl:element name="feedback">
               <xsl:value-of select="feedback"/>
            </xsl:element>
         </xsl:if>
         <xsl:if test="feedbackDelay = true()">
            <xsl:element name="feedbackDelay">
               <xsl:value-of select="feedbackDelay"/>
            </xsl:element>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="independentInput = true()">
               <xsl:element name="independentInput">
                  <xsl:value-of select="independentInput"/>
               </xsl:element>
            </xsl:when>
            <xsl:otherwise>
               <xsl:element name="independentInput">
                  <xsl:choose>
                     <!-- if no feedback used, the line is used as independent input -->
                     <xsl:when test="feedbackVariant = 'F0'">
                        <xsl:text>ST_YES</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>ST_NO</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:element>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!--  copy the RLHVI node with all childrens by applying templates ( template LSNRELAY obove must be performed) 
          add INPUT nodes if needed -->
   <xsl:template match="RLHVI">
      <xsl:element name="RLHVI">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name() = 'LSNRELAY'">
                  <xsl:apply-templates select="."/>
                  <!-- INPUTS are first allowed as children of RLHV from schema 2.1.0 on -->
                  <xsl:if test="INPUT = false()">
                     <!-- if the first LSNRELAY is not used was feedback we need an additional node INPUT (siNumber is set th zero like done by RPS) -->
                     <xsl:if test="LSNRELAY[1]/feedbackVariant = 'F0'">
                        <xsl:call-template name="AddINPUT">
                           <xsl:with-param name="PortNbr" select="number(LSNRELAY[1]/port) + 2"/>
                        </xsl:call-template>
                     </xsl:if>
                     <!-- if the second LSNRELAY is not used was feedback we need an additional node INPUT (siNumber is set th zero like done by RPS) -->
                     <xsl:if test="LSNRELAY[2]/feedbackVariant = 'F0'">
                        <xsl:call-template name="AddINPUT">
                           <xsl:with-param name="PortNbr" select="number(LSNRELAY[2]/port) + 2"/>
                        </xsl:call-template>
                     </xsl:if>
                  </xsl:if>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="MSS400 | MSS401">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="drillPattern = false()">
            <xsl:element name="drillPattern">
               <xsl:text>MP_ACM_CONTINOUS</xsl:text>
            </xsl:element>
         </xsl:if>
         <xsl:if test="drillVolume = false()">
            <xsl:element name="drillVolume">
               <xsl:text>4</xsl:text>
            </xsl:element>
         </xsl:if>
         <xsl:if test="testActivationPattern = false()">
            <xsl:element name="testActivationPattern">
               <xsl:text>MP_ACM_CONTINOUS</xsl:text>
            </xsl:element>
         </xsl:if>
         <xsl:if test="testActivationVolume = false()">
            <xsl:element name="testActivationVolume">
               <xsl:text>4</xsl:text>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="NAC_ZONE">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="drillPattern = false()">
            <xsl:element name="drillPattern">
               <xsl:text>MP_ACM_CONTINOUS</xsl:text>
            </xsl:element>
         </xsl:if>
         <xsl:if test="testActivationPattern = false()">
            <xsl:element name="testActivationPattern">
               <xsl:text>MP_ACM_CONTINOUS</xsl:text>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="NAC_ACTION">
      <xsl:element name="NAC_ACTION">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name() = 'duration'">
                  <xsl:apply-templates select="."/>
                  <xsl:if test="../volume = false()">
                     <xsl:element name="volume">
                        <xsl:variable name="SiNumber" select="ancestor::NAC_GROUP/siNumber"/>
                        <xsl:variable name="SubNumber" select="ancestor::NAC/subNumber"/>
                        <xsl:variable name="PhysNode" select="ancestor::NODE/descendant::MSS400|ancestor::NODE/descendant::MSS401"/>
                        <xsl:if test="user:ResetMax()"/>
                        <xsl:for-each select="$PhysNode[siNumber = $SiNumber]">
                           <xsl:if test="user:SetMax(number(volume))"/>
                        </xsl:for-each>
                        <xsl:value-of select="user:GetMax()"/>
                     </xsl:element>
                  </xsl:if>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- EN 54-2 sum of PANEL/PASacknowledge and GROUP/investigationTime must not be greater 10 minutes-->
   <xsl:template match="GROUP/investigationTime">
      <xsl:element name="investigationTime">
         <xsl:variable name="SumTime" select="number(ancestor::PANEL/PASacknowledge) + number(.) * 60"/>
         <xsl:choose>
            <xsl:when test="$SumTime &gt; 600">
               <xsl:variable name="ToMuch" select="$SumTime - 600"/>
               <xsl:value-of select="floor(number(.) - $ToMuch div 60)"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="."/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- EN 54-2 minimum of PANEL/andDelay is 300 -->
   <xsl:template match="PANEL/andDelay">
      <xsl:element name="andDelay">
         <xsl:choose>
            <xsl:when test="number(.) &lt; 300">
               <xsl:text>300</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="."/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="TRANSFER/maxPipeBytepoolSize">
      <xsl:element name="maxPipeBytepoolSize">
         <xsl:text>8192</xsl:text>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="NETWORK_INFO">
      <xsl:element name="NETWORK_INFO">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="bypassNACsRange = false()">
            <xsl:element name="bypassNACsRange">
               <xsl:text>BPR_ALL</xsl:text>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <!-- -->
   <xsl:template match="ACTIVITYTEXTS">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="info_alarm = false()">
            <xsl:element name="info_alarm">
               <xsl:text>

</xsl:text>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- new in 2.5.1 for EN54-13 -->
   <!-- Add en5413Enaled as last element to GLTZONE if not already there -->
   <xsl:template match="GLTZONE">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
         <xsl:if test="en5413Enabled = false()">
            <xsl:element name="en5413Enabled">
               <xsl:text>ST_NO</xsl:text>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- Extend LSN-Modules -->
   <xsl:template match="LSN1500_MODULE | LSN300_MODULE">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
            <xsl:choose>
               <xsl:when test="name(.) = 'creepingShortDetectionOff' and following-sibling::en5413Enabled = false()">
                  <!-- not yet en4513Enabled -->
                  <xsl:element name="en5413Enabled">ST_NO</xsl:element>
                  <xsl:element name="detect4wShort">ST_NO</xsl:element>
                  <xsl:element name="aux1CreepI_max">0</xsl:element>
                  <xsl:element name="aux2CreepI_max">0</xsl:element>
               </xsl:when>
               <xsl:when test="name(.) = 'en5413Enabled' and following-sibling::detect4wShort = false()">
                  <!-- not yet detect4wShort -->
                  <xsl:element name="detect4wShort">ST_NO</xsl:element>
                  <xsl:element name="aux1CreepI_max">0</xsl:element>
                  <xsl:element name="aux2CreepI_max">0</xsl:element>
               </xsl:when>
               <xsl:when test="name(.) = 'detect4wShort' and following-sibling::aux1CreepI_max = false()">
                  <!-- not yet aux1CreepI_max -->
                  <xsl:element name="aux1CreepI_max">0</xsl:element>
                  <xsl:element name="aux2CreepI_max">0</xsl:element>
               </xsl:when>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- Add en5413Enaled after  nrOfDetectors  if not already there -->
   <xsl:template match="GLTZONE_LSNI_CONV4">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
            <xsl:if test="name(.) = 'nrOfDetectors' and following-sibling::en5413Enabled = false()">
               <xsl:element name="en5413Enabled">ST_NO</xsl:element>
            </xsl:if>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- In 2.1.1 convert MP_ET_NORMAL_DAY to MP_ET_NORMAL-->
   <!-- In 2.5.1 convert MP_ET_ALARM_DAY to MP_ET_FIRE_DAY -->
   <!-- In 2.5.1 convert MP_ET_ALARM_WALKTEST to MP_ET_FIRE_WALKTEST -->
   <xsl:template match="COUNTER/cstate |  TRIGGER_STATE/oldstate | TRIGGER_STATE/newstate  | CONDITION_STATE/compoundState">
      <xsl:element name="{name()}">
         <xsl:choose>
            <xsl:when test=". = 'MP_ET_NORMAL_DAY'">
               <xsl:text>MP_ET_NORMAL</xsl:text>
            </xsl:when>
            <xsl:when test=". = 'MP_ET_ALARM_DAY'">
               <xsl:text>MP_ET_FIRE_DAY</xsl:text>
            </xsl:when>
            <xsl:when test=". = 'MP_ET_ALARM_WALKTEST'">
               <xsl:text>MP_ET_FIRE_WALKTEST</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="."/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- CONVERSION of NEW LSN-Structure BEGIN -->
   <!-- 	this template specializes the generic match=* - template. It is called for all elements of an LSN-device-node and behaves like match=* without a mode with one exception:
			LSN-elements which are in the list of t-table devices shall not be written, what is performed by a specialized template  with mode -->
   <xsl:template match="*" mode="InLSNNode">
      <xsl:element name="{name()}">
         <xsl:apply-templates select="@* | node()"/>
      </xsl:element>
   </xsl:template>
   <!-- template for all LSN-device-nodes which can be used with T-tapping shall not be written if found inside other LSN-device-nodes -->
   <xsl:template match="DM210 | PULLSTATION | T220IUS | T410I | O220IUS | OT220IUS | OTC220IUS | O500IUS |  OC500IUS | O500I | O410I | OC410I | OT410I | OTC410I | LSN_NAC | RLHVI | OC500I | ISOLATOR | LSNI_OUT2 | LSNI_OUT2_D | LSNI_IN2 | LSNI_IN2_D | LSNI_RELAY1 | LSNI_RELAY1_D | RAS_TPS1 | RAS_TPS2 | RAS_TTS1 | RAS_TTS2 | RAS_TMS | RAS_TMS_NOFAN | RAS_TMS_RB | LSNI_CONV4 | LSNI_RELAY8 | LSNI_BEACON | LSNI_IN8R1 | LSNI_OUT8_IN2 | LSNI_IN1 | LSNI_OUT1_IN1 | LSNI_RLE | FULLEON_BASE | FULLEON_STANDALONE | KD55_KD200 | LSNI_EOL_2W | LSNI_EOL_4W | DO410I | DOT410I  | DOTC410I" mode="InLSNNode">
      <xsl:variable name="EName" select="name()"/>
      <xsl:variable name="COMAdr" select="comAdr"/>
      <xsl:comment>
         <xsl:text>element moved: name = </xsl:text>
         <xsl:value-of select="$EName"/>
         <xsl:text>, comAdr = </xsl:text>
         <xsl:value-of select="$COMAdr"/>
      </xsl:comment>
   </xsl:template>
   <!-- normal handling of LSN-device-node -->
   <xsl:template match="DOW1171 | ATX100 | O500 | OC500 | FBF100 | FK100 | MSS400 | MSS401 | NAK100 | NBK100 | NBM110 | NEV300 | NIM100 | NKK100 | NOM100 | NSB100 | NTK100 | NTM100 | O410 | OC410 | OM200 | OT200 | OT410 | OTC410 | T410 | TM200 | DM210 | PULLSTATION | T220IUS | T410I | O220IUS | OT220IUS | OTC220IUS | O500IUS |  OC500IUS | O500I | O410I | OC410I | OT410I | OTC410I | LSN_NAC | RLHVI | OC500I | ISOLATOR | LSNI_OUT2 | LSNI_OUT2_D | LSNI_IN2 | LSNI_IN2_D | LSNI_RELAY1 | LSNI_RELAY1_D | RAS_TPS1 | RAS_TPS2 | RAS_TTS1 | RAS_TTS2 | RAS_TMS | RAS_TMS_NOFAN | RAS_TMS_RB | LSNI_CONV4 | LSNI_RELAY8 | LSNI_BEACON | LSNI_IN8R1 | LSNI_OUT8_IN2 | LSNI_IN1 | LSNI_OUT1_IN1 | LSNI_RLE | FULLEON_BASE | FULLEON_STANDALONE | KD55_KD200 | LSNI_EOL_2W | LSNI_EOL_4W | DO410I | DOT410I  | DOTC410I">
      <xsl:variable name="ElementName" select="name()"/>
      <xsl:choose>
         <xsl:when test="backPointer = false()">
         <!-- Convert to new LSN-structure -->
            <xsl:element name="{name()}">
               <xsl:variable name="BackPointer">
                  <xsl:choose>
                     <!-- if ttapping backPointer is comAdr of parent -->
                     <xsl:when test="ancestor::LSN300_MODULE/mode = 'LSN_TTAP' or ancestor::LSN1500_MODULE/mode = 'LSN_TTAP'">
                        <xsl:choose>
                           <xsl:when test="../comAdr">
                              <xsl:value-of select="../comAdr"/>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:choose>
                                 <!-- if the first element is under  a second LS_BUS, its a stub and the backpointer must be 255-->
                                 <xsl:when test="ancestor::LSN_BUS/port = '2'">255</xsl:when>
                                 <xsl:otherwise>0</xsl:otherwise>
                              </xsl:choose>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:when>
                     <!-- if NOTttapping backPointer is comAdr of last preceding-sibling -->
                     <xsl:otherwise>
                        <xsl:choose>
                           <xsl:when test="preceding-sibling::*/comAdr">
                              <xsl:value-of select="preceding-sibling::*[1]/comAdr"/>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:choose>
                                 <xsl:when test="../../LSN_BUS_NAK100 = true() or ../../LSN_BUS_FK100 = true()">
                                    <xsl:value-of select="../../comAdr"/>
                                 </xsl:when>
                                 <xsl:otherwise>
                                    <xsl:choose>
                                       <!-- if the first element is under  a second LS_BUS, its a stub and the backpointer must be 255-->
                                       <xsl:when test="ancestor::LSN_BUS/port = '2'">255</xsl:when>
                                       <xsl:otherwise>0</xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <xsl:element name="lsnTypeID">
                  <xsl:variable name="Condition" select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/@condition"/>
                  <xsl:choose>
                     <xsl:when test="descendant::siType = $Condition">
                        <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName and @condition = $Condition]/lsnTypeID"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/lsnTypeID"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:element>
               <xsl:element name="lsnSubtype">
                  <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/lsnSubtype"/>
               </xsl:element>
               <xsl:element name="backPointer">
                  <xsl:value-of select="$BackPointer"/>
               </xsl:element>
               <xsl:choose>
                  <xsl:when test="$ElementName = 'NAK100'">
                     <xsl:element name="branch">
                        <xsl:value-of select="LSN_BUS_NAK100/*[1]/comAdr"/>
                     </xsl:element>
                  </xsl:when>
                  <xsl:when test="$ElementName = 'FK100'">
                     <xsl:element name="branch">
                        <xsl:value-of select="LSN_BUS_FK100/*[1]/comAdr"/>
                     </xsl:element>
                  </xsl:when>
               </xsl:choose>
               <xsl:for-each select="*">
                  <xsl:apply-templates select="." mode="InLSNNode"/>
               </xsl:for-each>
            </xsl:element>
            <!-- now write an LSN-device-node which was found inside the LSN-device-node because of beeing t-tappable -->
            <xsl:for-each select="DM210 | PULLSTATION | T220IUS | T410I | O220IUS | OT220IUS | OTC220IUS | O500IUS |  OC500IUS | O500I | O410I | OC410I | OT410I | OTC410I | LSN_NAC | RLHVI | OC500I | ISOLATOR | LSNI_OUT2 | LSNI_OUT2_D | LSNI_IN2 | LSNI_IN2_D | LSNI_RELAY1 | LSNI_RELAY1_D | RAS_TPS1 | RAS_TPS2 | RAS_TTS1 | RAS_TTS2 | RAS_TMS | RAS_TMS_NOFAN | RAS_TMS_RB | LSNI_CONV4 | LSNI_RELAY8 | LSNI_BEACON | LSNI_IN8R1 | LSNI_OUT8_IN2 | LSNI_IN1 | LSNI_OUT1_IN1 | LSNI_RLE | FULLEON_BASE | FULLEON_STANDALONE | KD55_KD200 | LSNI_EOL_2W | DO410I | DOT410I  | DOTC410I">
               <xsl:apply-templates select="."/>
            </xsl:for-each>
         </xsl:when>
         <xsl:otherwise>
         <!-- already converted to new LSN-structure -->
            <xsl:element name="{name()}">
               <xsl:for-each select="*">
                  <xsl:apply-templates select="."/>
               </xsl:for-each>
            </xsl:element>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <!-- CONVERSION of NEW LSN-Structure END -->
   <!--   Refactor AUXPOWER   -->
   <xsl:template match="AUXPOWER">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name() = 'batteryBackup'">
                  <xsl:if test="ancestor::BATTERY_CONTR_MODULE = true()">
                     <xsl:apply-templates select="."/>
                  </xsl:if>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
         <xsl:if test="LINE_SUPERVISION = false()">
            <xsl:if test="name(../.) = 'LSN1500_MODULE' or name(../.) = 'LSN300_MODULE' or name(../.) = 'BCMB_MODULE'">
               <xsl:element name="LINE_SUPERVISION">
                  <xsl:element name="physAddrOfEOLDevice">0.0.0.0</xsl:element>
                  <xsl:element name="isConventional">ST_NO</xsl:element>
               </xsl:element>
            </xsl:if>   
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <msxsl:script language="javascript" implements-prefix="user">
   var maxVal = 0;
   function SetMax(value)
   {
     if(value > maxVal)
     {
       maxVal = value;
     }
     return true;
   }
   function ResetMax()
   {
     maxVal = 0;
     return true;
   }
   function GetMax()
   {
     return maxVal;
   }
</msxsl:script>
   <!-- -->
</xsl:stylesheet>
